#include "SetEntityPositionCommand.h"
#include "SimulationEngineController.h"
#include "../DataTypes/DataString.h"

namespace SimulationEngine
{

SetEntityPositionCommand::SetEntityPositionCommand(ISimEntity *entity):ICommand(ConfigurationServer::GetInstance()->GetCommandSetEntityPositionKey())
{
	this->entity = entity;
}

SetEntityPositionCommand::~SetEntityPositionCommand()
{
}

list<DataParameter*> SetEntityPositionCommand::execute(list <DataParameter *> pars)
{
	Vector3f *posvec = (Vector3f *)(pars.front());
	entity->SetEntityPosition(posvec->GetFirst(), posvec->GetSecond(), posvec->GetThird());
	list <DataParameter *> ret;
	ret.push_back(new DataString("Entity position has been successfully setted"));
	return ret;
}

}
